/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.framework.Tool;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.pdraw.action.ToolSelectionAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.simulation.SimulationTool;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;

public class SimulationToolAction
extends ToolSelectionAction {
    private SimulationTool fTool;

    public SimulationToolAction() {
        this.putValue("Name", "simulation tool");
        this.putValue("textKey", "extra.simulation");
        this.putValue("SmallIcon", Global.getIcon("Simulation.gif"));
    }

    public boolean prepareAction() {
        Iterator views = Application.getInstance().getMdiManager().getViews().iterator();
        if (this.isSelected()) {
            int simulateCnt = 0;
            while (views.hasNext()) {
                if (((LogoComfort)((LogoDrawingView)views.next()).editor()).tool().getClass() != SimulationTool.class) continue;
                ++simulateCnt;
            }
            if (simulateCnt >= 2) {
                LogoError error = new LogoError((Component)this.getOwner().getWindow(), "msg.tooManySimulation", "There are two circuit diagrams in the simulation. The others can not be simulated.", 2, 0);
                error.display();
                return false;
            }
        }
        return true;
    }

    public void actionPerformed(ActionEvent arg1) {
        super.actionPerformed(arg1);
    }

    public boolean doIt() {
        if (this.isSelected()) {
            LogoComfort logoComfort = (LogoComfort)this.getOwner();
            if (!logoComfort.checkDrawing()) {
                return false;
            }
            logoComfort.setTool(this.getTool(), Language.getString("pdraw.app.createTools.simulation", "simulation tool"), this);
        } else {
            super.doIt();
        }
        return true;
    }

    private Tool getTool() {
        if (this.fTool == null) {
            this.fTool = new SimulationTool((LogoComfort)this.getOwner());
        }
        this.fTool.iniNetworkToolbar();
        return this.fTool;
    }
}

